DROP INDEX LOBR.FILEIMG_PK;

CREATE UNIQUE INDEX LOBR.FILEIMG_PK ON LOBR.FILE_IMAGE
(FILE_IMAGE_ID)
LOGGING
TABLESPACE L_LOBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX LOBR.FILEIMG_FILEATCH_FK_I;

CREATE INDEX LOBR.FILEIMG_FILEATCH_FK_I ON LOBR.FILE_IMAGE
(FILE_ATTACHMENT_ID)
LOGGING
TABLESPACE L_LOBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX LOBR.FILEATT_DNSENRAPP_FK_I;

CREATE INDEX LOBR.FILEATT_DNSENRAPP_FK_I ON LOBR.FILE_ATTACHMENT
(DNS_ENROLLMENT_APP_ID)
LOGGING
TABLESPACE L_LOBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX LOBR.FILEATT_PK;

CREATE UNIQUE INDEX LOBR.FILEATT_PK ON LOBR.FILE_ATTACHMENT
(FILE_ATTACHMENT_ID)
LOGGING
TABLESPACE L_LOBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX LOBR.FILEATCHDT_PK;

CREATE UNIQUE INDEX LOBR.FILEATCHDT_PK ON LOBR.FILE_ATTACHMENT_DETAIL
(FILE_ATTACHMENT_DETAIL_ID)
LOGGING
TABLESPACE L_LOBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX LOBR.FILEATCHDTL_FILEATCH_FK_I;

CREATE INDEX LOBR.FILEATCHDTL_FILEATCH_FK_I ON LOBR.FILE_ATTACHMENT_DETAIL
(FILE_ATTACHMENT_ID)
LOGGING
TABLESPACE L_LOBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX LOBR.FILEATCHDTL_ELGDOCTYP_UK_I;

CREATE INDEX LOBR.FILEATCHDTL_ELGDOCTYP_UK_I ON LOBR.FILE_ATTACHMENT_DETAIL
(STD_ELIGDOCTYPE_ID)
LOGGING
TABLESPACE L_LOBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
